/****** Object:  UserDefinedFunction [dbo].[UFD_REL_FLUXO_ANALIT_RECEITA]    Script Date: 10/09/2012 14:18:21 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_REL_FLUXO_ANALIT_RECEITA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_REL_FLUXO_ANALIT_RECEITA]
GO  
--SELECT * FROM UFD_REL_FLUXO_ANALIT_RECEITA (1,'0.0.0.00.0000','2017-08-01','2017-08-31', 0, 3) WHERE NR_DP=1700001
CREATE   FUNCTION [dbo].[UFD_REL_FLUXO_ANALIT_RECEITA](
		@CD_EMP       INT,
		@NR_CNT       VARCHAR(250),
		@DT_INI	      DATETIME,	
		@DT_FIM	      DATETIME,
		@TP	          INT,
		@TP_DT        INT)

RETURNS @RETORNO_FLUXO TABLE(		
		CD_DESP_REC INT,
		CD_CHAVE	VARCHAR(250),		
		NR_DP		INT,	
		PARC		INT,		
		DT_EMI		DATETIME,	
		DT_SEL_REL	DATETIME,	
		DT_PGTO		DATETIME,	
  		CD_EMP		INT,
		CD_FILIAL	INT,		
		CD_TP_FORN  INT,
		DS_DESP_REC VARCHAR(250),
		DOC			VARCHAR(250),
		HIST		VARCHAR(500),
		VLR_DP		MONEY,
		VLR_SLD		MONEY,
		VLR_RECTA	MONEY,	
		DS_TP		VARCHAR(150),
		TRANSACAO	VARCHAR (60),
		NM_CLI	VARCHAR(300))


AS
BEGIN	

	INSERT INTO @RETORNO_FLUXO
		SELECT     
				GLB_DESP_REC.CD_DESP_REC,
				GLB_DESP_REC.NR_CNT, 		
				BC_LANC.CD_BC_LANC AS NR_DP, 
				0 AS PARC,
				BC_LANC.DT_LANCTO AS DT_EMI_NF, 	
				(CASE WHEN @TP_DT = 3 THEN 
					RC_RECTA_RAT.MES_ANO_REF 
				ELSE 
					BC_LANC.DT_LANCTO 
				END) AS DT_SEL_REL,	
				BC_LANC.DT_LANCTO DT_PGTO,
				RC_RECTA_RAT.CD_EMP, 
				RC_RECTA_RAT.CD_FILIAL, 		
				ISNULL(PG_TP_FORN.CD_TP_FORN,0) AS CD_TP_FORN,
				GLB_DESP_REC.DS_DESP_REC, 		
				BC_LANC.CD_BC_LANC AS DOC, 
				BC_LANC.HIST_LANC AS HIST,
				BC_LANC.VLR_LANC AS VLR_DP,
				0 AS VLR_SLD,
				RC_RECTA_RAT.VLR_RECTA AS VLR_RECTA,
				PG_TP_FORN.DS_TP,
				'BANCARIO' AS TRANSACAO,
				'LANCAMENTO DIRETO BANCARIO' AS NM_CLI	
		FROM         
				BC_LANC 
				INNER JOIN RC_RECTA_RAT_BC_LANC ON 		
				BC_LANC.CD_EMP = RC_RECTA_RAT_BC_LANC.CD_EMP AND 	
				BC_LANC.CD_BC_LANC = RC_RECTA_RAT_BC_LANC.CD_BC_LANC 
				
				INNER JOIN RC_RECTA_RAT ON 
				RC_RECTA_RAT_BC_LANC.CD_EMP = RC_RECTA_RAT.CD_EMP AND 
				RC_RECTA_RAT_BC_LANC.CD_RAT_RECTA = RC_RECTA_RAT.CD_RAT_RECTA 
				
				INNER JOIN GLB_DESP_REC ON 
				RC_RECTA_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND 
				RC_RECTA_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC

				INNER JOIN RC_TP_LANC ON 
				BC_LANC.CD_EMP = RC_TP_LANC.CD_EMP AND 
				BC_LANC.CD_TP_LANC = RC_TP_LANC.CD_TP_LANC 

				INNER JOIN PG_TP_FORN ON 
				RC_TP_LANC.CD_EMP = PG_TP_FORN.CD_EMP AND 
				RC_TP_LANC.CD_CLASS_FLUXO_CX = PG_TP_FORN.CD_TP_FORN
		WHERE     
				BC_LANC.CD_EMP = @CD_EMP	
				AND (CASE WHEN @TP_DT = 3 THEN RC_RECTA_RAT.MES_ANO_REF 
					ELSE BC_LANC.DT_LANCTO END) BETWEEN @DT_INI AND @DT_FIM  					
				AND (CASE WHEN @TP = 0 THEN @NR_CNT ELSE GLB_DESP_REC.NR_CNT END) = @NR_CNT		        

		INSERT INTO @RETORNO_FLUXO
		SELECT     
		
				GLB_DESP_REC.CD_DESP_REC,
				GLB_DESP_REC.NR_CNT, 		
				RC_ADM_CARTAO_MOV.CD_CTR AS NR_DP, 
				0 AS PARC,
				RC_ADM_CARTAO_MOV.DT_LANC AS DT_EMI_NF, 	
				(CASE WHEN @TP_DT = 3 THEN 
					RC_RECTA_RAT.MES_ANO_REF 
				ELSE 
					RC_ADM_CARTAO_MOV.DT_LANC 
				END) AS DT_SEL_REL,	
				RC_ADM_CARTAO_MOV.DT_LANC DT_PGTO,
				RC_RECTA_RAT.CD_EMP, 
				RC_RECTA_RAT.CD_FILIAL, 		
				0 AS CD_TP_FORN, 	
				GLB_DESP_REC.DS_DESP_REC,			
				RC_ADM_CARTAO_MOV.CD_CTR AS DOC, 
				RC_ADM_CARTAO_MOV.HIST_LANC AS HIST,
				RC_ADM_CARTAO_MOV.VLR_LANC AS VLR_DP,
				0 AS VLR_SLD,
				RC_RECTA_RAT.VLR_RECTA AS VLR_RECTA,
				PG_TP_FORN.DS_TP,
				'CARTAO DE CREDITO' AS TRANSACAO,
				RC_CLI.NM_FANT AS NM_CLI
				
		FROM	RC_ADM_CARTAO_MOV 
				INNER JOIN RC_RECTA_RAT_RC_ADM_CARTAO_MOV ON
				RC_ADM_CARTAO_MOV.CD_EMP = RC_RECTA_RAT_RC_ADM_CARTAO_MOV.CD_EMP AND
				RC_ADM_CARTAO_MOV.CD_CTR  = RC_RECTA_RAT_RC_ADM_CARTAO_MOV.CD_CTR 

				INNER JOIN RC_RECTA_RAT ON 
				RC_RECTA_RAT_RC_ADM_CARTAO_MOV.CD_EMP = RC_RECTA_RAT.CD_EMP AND
				RC_RECTA_RAT_RC_ADM_CARTAO_MOV.CD_RAT_RECTA = RC_RECTA_RAT.CD_RAT_RECTA	
				
				INNER JOIN GLB_DESP_REC ON 
				RC_RECTA_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND 
				RC_RECTA_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC	
				
				INNER JOIN RC_CLI ON
				RC_ADM_CARTAO_MOV.CD_EMP = RC_CLI.CD_EMP AND
				RC_ADM_CARTAO_MOV.CD_CLI = RC_CLI.CD_CLI
				
				INNER JOIN RC_TP_LANC ON 
				RC_CLI.CD_EMP = RC_TP_LANC.CD_EMP AND 
				RC_CLI.CD_TP_LANC = RC_TP_LANC.CD_TP_LANC 

				INNER JOIN PG_TP_FORN ON 
				RC_TP_LANC.CD_EMP = PG_TP_FORN.CD_EMP AND 
				RC_TP_LANC.CD_CLASS_FLUXO_CX = PG_TP_FORN.CD_TP_FORN     
		        
		WHERE     
				RC_ADM_CARTAO_MOV.CD_EMP = @CD_EMP	
				AND (CASE WHEN @TP_DT = 3 THEN RC_RECTA_RAT.MES_ANO_REF 
					ELSE RC_ADM_CARTAO_MOV.DT_LANC END) BETWEEN @DT_INI AND @DT_FIM  					
				AND (CASE WHEN @TP = 0 THEN @NR_CNT ELSE GLB_DESP_REC.NR_CNT END) = @NR_CNT	        
				AND RC_ADM_CARTAO_MOV.TP_LANC = CASE WHEN @TP=1 THEN 0 ELSE 1 END        

IF @TP_DT<>4
begin				
		INSERT INTO @RETORNO_FLUXO
		SELECT     
				GLB_DESP_REC.CD_DESP_REC,
				GLB_DESP_REC.NR_CNT, 		
				RC_DEB.NR_DP AS NR_DP, 
				RC_DEB.PARC,
				RC_DEB.DT_DP AS DT_EMI_NF, 	
				(CASE WHEN @TP_DT = 3 THEN 
					RC_RECTA_RAT.MES_ANO_REF 
				ELSE 
					RC_DEB.DT_DP 
				END) AS DT_SEL_REL,	
				NULL DT_PGTO,
				RC_RECTA_RAT.CD_EMP, 
				RC_RECTA_RAT.CD_FILIAL, 		
				0 AS CD_TP_FORN, 	
				GLB_DESP_REC.DS_DESP_REC,			
				RC_DEB.CD_RC_DEB AS DOC, 
				RC_DEB.HIST AS HIST,
				RC_DEB.VLR_DP AS VLR_DP,
				RC_DEB.SLD_DP AS VLR_SLD,
				RC_RECTA_RAT.VLR_RECTA * (convert(float,RC_DEB.VLR_DP)/V_RC_DEB_NR_PARC.VLR_TIT) AS VLR_RECTA,
				PG_TP_FORN.DS_TP,
				'CONTAS A RECEBER' AS TRANSACAO,
				RC_CLI.NM_FANT
		FROM	
			RC_DEB 
			INNER JOIN RC_RECTA_RAT_RC_DEB ON
			RC_DEB.CD_EMP = RC_RECTA_RAT_RC_DEB.CD_EMP AND
			RC_DEB.CD_FILIAL = RC_RECTA_RAT_RC_DEB.CD_FILIAL AND
			RC_DEB.NR_DP = RC_RECTA_RAT_RC_DEB.NR_DP AND
			RC_DEB.ANO = RC_RECTA_RAT_RC_DEB.ANO
			INNER JOIN V_RC_DEB_NR_PARC ON
			RC_DEB.CD_EMP = V_RC_DEB_NR_PARC.CD_EMP AND
			RC_DEB.CD_FILIAL = V_RC_DEB_NR_PARC.CD_FILIAL AND
			RC_DEB.NR_DP = V_RC_DEB_NR_PARC.NR_DP AND
			RC_DEB.ANO = V_RC_DEB_NR_PARC.ANO 
						
			INNER JOIN RC_RECTA_RAT ON
			RC_RECTA_RAT_RC_DEB.CD_EMP =  RC_RECTA_RAT.CD_EMP AND
			RC_RECTA_RAT_RC_DEB.CD_RAT_RECTA =  RC_RECTA_RAT.CD_RAT_RECTA

			INNER JOIN GLB_DESP_REC ON 
			RC_RECTA_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND 
			RC_RECTA_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC	
			INNER JOIN RC_CLI ON
			RC_DEB.CD_EMP = RC_CLI.CD_EMP AND
			RC_DEB.CD_CLI = RC_CLI.CD_CLI
			INNER JOIN RC_TP_LANC ON 
			RC_CLI.CD_EMP = RC_TP_LANC.CD_EMP AND 
			RC_CLI.CD_TP_LANC = RC_TP_LANC.CD_TP_LANC 

			INNER JOIN PG_TP_FORN ON 
			RC_TP_LANC.CD_EMP = PG_TP_FORN.CD_EMP AND 
			RC_TP_LANC.CD_CLASS_FLUXO_CX = PG_TP_FORN.CD_TP_FORN     
		WHERE     
				RC_DEB.CD_EMP = @CD_EMP	
				AND  RC_DEB.STS_DP <> 3     
				AND (CASE WHEN @TP_DT = 0 THEN 
							RC_DEB.DT_DP
					 WHEN @TP_DT = 1 THEN
							RC_DEB.DT_DP
					 WHEN @TP_DT = 2 THEN 
							RC_DEB.DT_VENCTO
					 WHEN @TP_DT = 3 THEN 
							RC_RECTA_RAT.MES_ANO_REF 
					END) BETWEEN @DT_INI AND @DT_FIM  					
				AND (CASE WHEN @TP = 0 THEN @NR_CNT ELSE GLB_DESP_REC.NR_CNT END) = @NR_CNT	 
end

IF  @TP_DT=4
begin				
		INSERT INTO @RETORNO_FLUXO
		SELECT     
				GLB_DESP_REC.CD_DESP_REC,
				GLB_DESP_REC.NR_CNT, 		
				RC_DEB.NR_DP AS NR_DP, 
				RC_DEB.PARC,
				RC_DEB.DT_DP AS DT_EMI_NF, 	
				RC_CRED.DT_PAG AS DT_SEL_REL,	
				RC_CRED.DT_PAG DT_PGTO,
				RC_RECTA_RAT.CD_EMP, 
				RC_RECTA_RAT.CD_FILIAL, 		
				0 AS CD_TP_FORN, 	
				GLB_DESP_REC.DS_DESP_REC,			
				RC_DEB.CD_RC_DEB AS DOC, 
				RC_DEB.HIST AS HIST,
				RC_DEB.VLR_DP AS VLR_DP,
				RC_DEB.SLD_DP AS VLR_SLD,
				RC_RECTA_RAT.VLR_RECTA * (convert(float,RC_CRED.VL_PGTO)/V_RC_DEB_NR_PARC.VLR_TIT) AS VLR_RECTA,
				PG_TP_FORN.DS_TP,
				'CONTAS A RECEBER' AS TRANSACAO,
				RC_CLI.NM_FANT
		FROM	
			RC_DEB INNER JOIN RC_CRED ON
			RC_DEB.CD_EMP = RC_CRED.CD_EMP AND
			RC_DEB.CD_FILIAL = RC_CRED.CD_FILIAL AND
			RC_DEB.CD_RC_DEB = RC_CRED.CD_RC_DEB 
			INNER JOIN V_RC_DEB_NR_PARC ON
			RC_DEB.CD_EMP = V_RC_DEB_NR_PARC.CD_EMP AND
			RC_DEB.CD_FILIAL = V_RC_DEB_NR_PARC.CD_FILIAL AND
			RC_DEB.NR_DP = V_RC_DEB_NR_PARC.NR_DP AND
			RC_DEB.ANO = V_RC_DEB_NR_PARC.ANO 

			
			INNER JOIN RC_RECTA_RAT_RC_DEB ON
			RC_DEB.CD_EMP = RC_RECTA_RAT_RC_DEB.CD_EMP AND
			RC_DEB.CD_FILIAL = RC_RECTA_RAT_RC_DEB.CD_FILIAL AND
			RC_DEB.NR_DP = RC_RECTA_RAT_RC_DEB.NR_DP AND
			RC_DEB.ANO = RC_RECTA_RAT_RC_DEB.ANO
			
			INNER JOIN RC_RECTA_RAT ON
			RC_RECTA_RAT_RC_DEB.CD_EMP =  RC_RECTA_RAT.CD_EMP AND
			RC_RECTA_RAT_RC_DEB.CD_RAT_RECTA =  RC_RECTA_RAT.CD_RAT_RECTA

			INNER JOIN GLB_DESP_REC ON 
			RC_RECTA_RAT.CD_EMP = GLB_DESP_REC.CD_EMP AND 
			RC_RECTA_RAT.CD_DESP_REC = GLB_DESP_REC.CD_DESP_REC	
			INNER JOIN RC_CLI ON
			RC_DEB.CD_EMP = RC_CLI.CD_EMP AND
			RC_DEB.CD_CLI = RC_CLI.CD_CLI
			INNER JOIN RC_TP_LANC ON 
			RC_CLI.CD_EMP = RC_TP_LANC.CD_EMP AND 
			RC_CLI.CD_TP_LANC = RC_TP_LANC.CD_TP_LANC 

			INNER JOIN PG_TP_FORN ON 
			RC_TP_LANC.CD_EMP = PG_TP_FORN.CD_EMP AND 
			RC_TP_LANC.CD_CLASS_FLUXO_CX = PG_TP_FORN.CD_TP_FORN     
		WHERE     
				RC_DEB.CD_EMP = @CD_EMP	
				AND RC_CRED.DT_PAG BETWEEN @DT_INI AND @DT_FIM  					
				AND (CASE WHEN @TP = 0 THEN @NR_CNT ELSE GLB_DESP_REC.NR_CNT END) = @NR_CNT	 
end
	RETURN
END